# Modified Euler Projectile Simulation
# Uses 7+33n Clock Cycles

# Set Initial Conditions
li $t0,0    # Y
li $t1,1000000 # V
li $t4,0    # Step Count
li $t5,0    # T
li $t6,15   # dT
li $t7,100  # Steps

MAINLOOP:

# While T < T_End
bge $t4,$t7,ENDPROGRAM


# CALCULATE FORWARD VALUE

# dYdT
mul $a0,$t1,$t6
add $t2,$t0,$a0

# dVydT
abs $a0,$t1
mult $a0,$t1
mfhi $a0
mul $a0,$a0,-23
addi $a0,$a0,-981
mul $a0,$a0,$t6
add $t3,$t1,$a0

# CALCULATE BACKWARD VALUE & AVERAGE

# dYdT
mul $a0,$t3,$t6
add $t0,$t0,$a0
add $t0,$t0,$t2
sra $t0,$t0,1

# dVydT
abs $a0,$t3
mult $a0,$t3
mfhi $a0
mul $a0,$a0,-23
addi $a0,$a0,-981
mul $a0,$a0,$t6
add $t1,$t1,$a0
add $t1,$t1,$t3
sra $t1,$t1,1

# Increment Time Counter
add $t5,$t5,$t6
addi $t4,$t4,1

j MAINLOOP

ENDPROGRAM:
