module vga(dclk, clr, hsync, vsync, red, green, blue);
input wire dclk, clr;
output wire hsync, vsync;
output [7:0] red, green, blue;


//constraints
parameter hpixels = 800;// horizontal pixels per line
parameter vlines = 521; // vertical lines per frame
parameter hpulse = 96; 	// hsync pulse length
parameter vpulse = 2; 	// vsync pulse length
parameter hbp = 144; 	// end of horizontal back porch
parameter hfp = 784; 	// beginning of horizontal front porch
parameter vbp = 31; 		// end of vertical back porch
parameter vfp = 511; 	// beginning of vertical front porch

reg [9:0] hc;
reg [9:0] vc;
reg [18:0] addr = 18'b000000000000000000;
wire[23:0] RGB;
always @(posedge dclk or posedge clr)
begin
	// reset condition
	if (clr == 1)
	begin
		hc <= 0;
		vc <= 0;
	end
	else
	begin
		// keep counting until the end of the line
		if (hc < hpixels - 1)
			hc <= hc + 1;
		else
		// When we hit the end of the line, reset the horizontal
		// counter and increment the vertical counter.
		// If vertical counter is at the end of the frame, then
		// reset that one too.
		begin
			hc <= 0;
			if (vc < vlines - 1)
				vc <= vc + 1;
			else
				vc <= 0;
		end
		
	end
end

// generate sync pulses (active low)
assign hsync = (hc < hpulse) ? 0:1;
assign vsync = (vc < vpulse) ? 0:1;
 
always @(hc,vc)
begin
	// first check if we're within vertical active video range
	if (vc >= vbp && vc < vfp)
	begin
		if (hc >= hbp && hc < hfp)
		begin
			addr = addr + 1;
		end
	end
	// we're outside active vertical range so display black
	else
	begin
		addr = 0;
	end
end

ImgMem img1(addr, RGB);
assign red = (addr == 0) ? 0:RGB[23:16];
assign green = (addr == 0) ? 0:RGB[15:8];
assign blue = (addr == 0) ? 0:RGB[7:0];

endmodule

module testVGA;
//ConcattImm MemDataOut
reg clk;
reg ri,rising;
//reg[31:0] Input;
wire[18:0] Address;
wire[7:0] red,green,blue;
wire[9:0] H,V;
wire[23:0] RedGreen;
wire clr,hsync,vsync;
always @(posedge clk) ri=rising;


vga display(clk, clr, hsync, vsync, red, green, blue);



initial clk=0;
always #10 clk=!clk;

initial begin


end

endmodule




