module vga640x480(
                input wire dclk,                                 //pixel clock: 25MHz
                input wire clr,                                    //asynchronous reset
                output wire hsync,                          //horizontal sync ~31.5 Khz
                output wire vsync,                          //vertical sync out ~60Hhz
                output reg red,      
                output reg green, 
                output reg blue    
                );


parameter hpixels = 800;// horizontal pixels per line
parameter vlines = 521; // vertical lines per frame
parameter hpulse = 96;                 // hsync pulse length
parameter vpulse = 2;    // vsync pulse length
parameter hbp = 144;    // end of horizontal back porch
parameter hfp = 784;     // beginning of horizontal front porch
parameter vbp = 31;       // end of vertical back porch
parameter vfp = 511;      // beginning of vertical front porch
// 784 - 144 = 640 pixels on display
// 511 - 31 = 480 pixels vertically


reg [9:0] hc; //vertical counter
reg [9:0] vc; //horizontal counter

// Horizontal & vertical counter stuff

always @(posedge dclk or posedge clr)
begin
                // reset condition
                if (clr == 1)
                begin
                                hc <= 0;
                                vc <= 0;
                end
                else
                begin
                                // keep counting until the end of the line
                                if (hc < hpixels - 1)
                                                hc <= hc + 1;
                                else // horizontal at end
                                //reset the horizontal at end of line, incredment vertical by one
                                // reset vertical iif at end
                               
                                begin
                                                hc <= 0;
                                                if (vc < vlines - 1) //norm vert
                                                                vc <= vc + 1;
                                                else //end of vert
                                                                vc <= 0;
                                end
                                
                end
end

// generate sync pulses (active low)
// ----------------
// "assign" statements are a quick way to
// give values to variables of type: wire
assign hsync = (hc < hpulse) ? 0:1; // if less than pulse length zero
assign vsync = (vc < vpulse) ? 0:1; 

always @(hc,vc)
 if (vc >= vbp && vc < vfp) //in active screen vertically
                begin
                                // dif color every 80 pixels

                                if (hc >= hbp && hc < (hbp+80)) //white
                                begin
                                                red = 1;
                                                green = 1;
                                                blue = 1;
                                end
                                // display yellow bar
                                else if (hc >= (hbp+80) && hc < (hbp+160))
                                begin
                                                red = 1;
                                                green = 1;
                                                blue = 0;
                                end
                                // display cyan bar
                                else if (hc >= (hbp+160) && hc < (hbp+240))
                                begin
                                                red = 0;
                                                green = 1;
                                                blue = 1;
                                end
                                // display green bar
                                else if (hc >= (hbp+240) && hc < (hbp+320))
                                begin
                                                red = 0;
                                                green = 1;
                                                blue = 0;
                                end
                                // display magenta bar
                                else if (hc >= (hbp+320) && hc < (hbp+400))
                                begin
                                                red = 1;
                                                green = 0;
                                                blue = 1;
                                end
                                // display red bar
                                else if (hc >= (hbp+400) && hc < (hbp+480))
                                begin
                                                red = 1;
                                                green = 0;
                                                blue = 0;
                                end
                                // display blue bar
                                else if (hc >= (hbp+480) && hc < (hbp+560))
                                begin
                                                red = 0;
                                                green = 0;
                                                blue = 1;
                                end
                                // display black bar
                                else if (hc >= (hbp+560) && hc < (hbp+640))
                                begin
                                                red = 0;
                                                green = 0;
                                                blue = 0;
                                end
                                // we're outside active horizontal range so display black
                                else
                                begin
                                                red = 0;
                                                green = 0;
                                                blue = 0;
                                end
                end
                // we're outside active vertical range so display black
                else
                begin
                                red = 0;
                                green = 0;
                                blue = 0;
                end

endmodule


module vgaTop(clk,red,green,blue,hsync,vsync);
input clk; 
output wire red,green,blue;
output wire vsync, hsync;
wire pclk;
wire dnc = 0;

ClkDivider pixelClk(clk, pclk);
vga640x480 display(pclk,dnc,hsync,vsync,red,green,blue);

endmodule

module ActualTop(clk,Red,Green,Blue,HS,VS);
input clk;
output Red, Green, Blue;
output HS, VS;

vgaTop vga(clk, Red,Green,Blue, HS, VS);

endmodule



module testVGA;
//TEST ON MODELSIM
reg clk;
reg ri,rising;
//reg[31:0] Input;
wire[18:0] Address;
wire[7:0] red,green,blue;
wire H,V;


always @(posedge clk) ri=rising;


vga640x480 display(clk, clr, H, V, red, green, blue);



initial clk=0;
always #10 clk=!clk;

initial begin


end

endmodule