import midi

filesource = raw_input('Enter a file name: ')
data = midi.read_midifile(filesource) # read file
# resolution = data.resolution # get ticks per beat

#default values (specifically for "All About That Bass")
resolution = 480
usPerBeat = 443047  # microseconds, 135bpm here
tickLength = 923 # also microseconds
# cycleLength ASSIGN THIS TO TIME FOR ONE FPGA CLOCK CYCLE (not necessary if hard coded)
# Remember that time per tick / time per clock cycle = clock cycles per tick
octavemap = {0:'0000', 1:'0001', 2:'0010', 3:'0011', 4:'0100',
             5:'0101', 6:'0110', 7:'0111', 8:'1000'} # octaves 0 through 8
pitchmap = {9:'000000000001', 10:'000000000010', 11:'000000000100', 0:'000000001000', 1:'000000010000', 2:'000000100000', 
            3:'000001000000', 4:'000010000000', 5:'000100000000', 6:'001000000000', 7:'010000000000', 8:'100000000000'} #12 bits for chromatic scale

# end product is 29 bits (4 for octave, 12 for pitch, 13 for note length)
maxNoteLength = 0

filedest = 'mem.dat'
f = open(filedest,'w')
eventlist =[]

for i in range(len(data)): # iterate through all tracks

    track = data[i]
    # minLength = sorted([50,len(track)])[0]

    for j in range(len(track)): # iterate through every line
    # for j in range(minLength): # iterate through up to 50 lines of every track
        line = track[j]
        # below block is not necessary if tempo is hard coded
        if type(line) == midi.events.SetTempoEvent: # look for tempo changes
            usPerBeatString = "" # microseconds
            for hexbyte in line.data:
              usPerBeatString += hex(hexbyte)[2:] # always positive hopefully since negative ms per beat is nonsense
            usPerBeat = int(usPerBeatString,16)
            tickLength = usPerBeat/resolution # microseconds per beat / resolution (ticks per beat) = microseconds per tick
            # cyclesPerTick = tickLength / cycleLength # convert from actual time into FPGA time

        event = []
        
        if (type(line) == midi.events.NoteOnEvent) and (line.data[1] != 0): # note on event
            eventlist.append(['0000','000000000000',bin(line.tick*cyclesPerTick)[2:].zfill(13)])# add rests in between notes - assumes that notes are sequential in a track
            f.write('0000000000000000' + bin(line.tick*cyclesPerTick)[2:].zfill(13)+'\n') # same as above
            octave, pitch = divmod(line.data[0], 12) # MIDI values range from 21-108 starting from A0 to C8
            octave -= 1 # Octaves range from 0 to 8, not 1 to 9
            event.append(octavemap[octave])
            event.append(pitchmap[pitch])
            noteLength = 0
            subtrack = track[j+1:len(track)] # all lines after this one
            for k in range(len(subtrack)):
                subline = subtrack[k]
                noteLength += subline.tick # sum up total delay between note on and note off events
                if (type(subline) == midi.events.NoteOffEvent) or ((type(subline) == midi.events.NoteOnEvent) and (subline.data[1] == 0)): # note off event
                    if subline.data[0] == line.data[0]:
                        # noteCycles = noteLength * cyclesPerTick # how long is the note in FPGA ticks?
                        noteCycles = noteLength # using this line means you have to hard code subdivision in FPGA clock
                        event.append(bin(noteCycles)[2:].zfill(13))
                        f.write(event[0]+event[1]+event[2]+'\n')
                        eventlist.append(event)
                        break
f.close()
# just prints out the entire thing in list format for your benefit
for event in eventlist:
    print(event)
print(len(eventlist))