// Address in, data out. Configure mem's length and width for your own song result. All About That Bass produces 1998 note events
module InstructionMemory(DataOut, Addr);
input[10:0] Addr;
output[28:0] DataOut;
reg [28:0] mem[1997:0];

initial $readmemb("mem.dat", mem,0,1997);
assign DataOut = mem[Addr];
endmodule

module SineSynth (sine_out, clk, notepitch, octave);
		input clk;
		input [11:0] notepitch;
		input [3:0] octave;
		reg [25:0] p_inc;
		wire [7:0] sine;
		output [7:0] sine_out;

		// p_inc apparently just multiplies pitch frequency by about 1.3425
		// Sound quality may not be the best because of limited precision in binary format.
		always @(*)
		begin
			if (notepitch[0] == 1)
			begin
				p_inc = 26'b100101 << octave; //A0 (27.5 Hz)
			end
			else if (notepitch[1] == 1)
			begin 
				p_inc = 26'b100111 << octave; //A0 sharp (29.1 Hz)
			end
			else if (notepitch[2] == 1)
			begin 
				p_inc = 26'b101001 << octave; //B0 (30.9 Hz)
			end
			else if (notepitch[3] == 1)
			begin 
				p_inc = 26'b101100 << octave; //C1 (32.7 Hz)
			end
			else if (notepitch[4] == 1)
			begin 
				p_inc = 26'b101110 << octave; // C1 sharp (34.6 Hz)
			end
			else if (notepitch[5] == 1)
			begin
				p_inc = 26'b110001 << octave; //D1 (36.7 Hz)
			end
			else if (notepitch[6] == 1)
			begin 
				p_inc = 26'b110100 << octave; // D1 sharp (38.9 Hz)
			end
			else if (notepitch[7] == 1)
			begin
				p_inc = 26'b110111 << octave; //E1 (41.2 Hz)
			end
			else if (notepitch[8] == 1)
			begin
				p_inc = 26'b111010 << octave; //F1
			end
			else if (notepitch[9] == 1)
			begin
				p_inc = 26'b111110 << octave; //F1 Sharp
			end
			else if (notepitch[10] == 1)
			begin
				p_inc = 26'b1000010 << octave; //G1
			end
			else if (notepitch[11] == 1)
			begin
				p_inc = 26'b1000110 << octave; //G1 Sharp
			end
			else
			begin
				p_inc = 26'b0 << octave;
			end
		end

    // Mysterious black box direct digital synthesizer
		dds_compiler_v4_0 DDS (
	   .clk(clk), // input clk
	   .pinc_in(p_inc), // input [25 : 0] pinc_in
	   .sine(sine) // output [7 : 0] sine
		);
    // If we have a sine wave, assign it to sine_out. Otherwise, sine_out is zero.
		assign sine_out = (notepitch[0] == 1) ? sine: (notepitch[1] == 1) ? sine: (notepitch[2] == 1) ? sine: (notepitch[3] == 1) ? sine: (notepitch[4] == 1) ? sine: (notepitch[5] == 1) ? sine: (notepitch[6] == 1) ? sine: (notepitch[7] == 1) ? sine: (notepitch[8] == 1) ? sine: (notepitch[9] == 1) ? sine: (notepitch[10] == 1) ? sine: (notepitch[11] == 1) ? sine: 8'b0;

endmodule

// Hooks the synthesizer and the memory together
module TopLevelSynth(sine_out_top, clk);
    input clk;
    output[7:0] sine_out_top;
    reg [10:0] address = 0;
	 reg [15:0] clkdivide = 0;
	 reg [12:0] notedivide = 0;
    wire [28:0] dataout;
	 wire [12:0] notelength;
    InstructionMemory inm(dataout,address);
    SineSynth ss(sine_out_top,clk,dataout[24:13],dataout[28:25]); // notepitch, octave respectively
	 
	 assign notelength = dataout[12:0];

	 always @(posedge clk) begin
    // One "tick" for All About That Bass is 923 microseconds
    // A clock cycle at 50mhz is 0.02 microseconds
    // time per tick / time per clock cycle = clock cycles per tick
		if (clkdivide == 46150) begin
			clkdivide = 0;
			notedivide = notedivide + 1;
      // Length of the memory above, just loop continuously
			if (address == 1997) begin
				address = 0;
			end
      // Have we played for the right number of ticks yet?
			if (notedivide == notelength) begin
				notedivide = 0;
				address = address + 1;
			end

		end
		else begin
			clkdivide = clkdivide + 1;
		end
	 end
    
endmodule

// Start up
module runSynth(sine_sig,clk);
    input clk;
    output [7:0] sine_sig;
	 
    TopLevelSynth tlsynth(sine_sig,clk);

endmodule
