module SineSynth (sine_sig, clk, switch);
		input clk;
		input [7:0] switch;
		output [7:0] sine_sig;
		reg [25:0] p_inc;
		wire [7:0] sine;

		always @(posedge clk)
		begin
			if (switch[0] == 1)
			begin
				p_inc = 26'b1001001111; //A (440 Hz)
			end
			else if (switch[1] == 1)
			begin
				p_inc = 26'b1010010111; //B
			end
			else if (switch[2] == 1)
			begin
				p_inc = 26'b1010111110; //C
			end
			else if (switch[3] == 1)
			begin
				p_inc = 26'b1100010100; //D
			end
			else if (switch[4] == 1)
			begin
				p_inc = 26'b1101110100; //E
			end
			else if (switch[5] == 1)
			begin
				p_inc = 26'b1110101001; //F
			end
			else if (switch[6] == 1)
			begin
				p_inc = 26'b10000011100; //G
			end
			else if (switch[7] == 1)
			begin
				p_inc = 26'b10010011101; //A
			end
			else
			begin
				p_inc = 26'b0;
			end
		end
					
		dds_compiler_v4_0 DDS (
	   .clk(clk), // input clk
	   .pinc_in(p_inc), // input [25 : 0] pinc_in
	   .sine(sine) // output [7 : 0] sine
		);
		
		assign sine_sig = (switch[0] == 1) ? sine: (switch[1] == 1) ? sine: (switch[2] == 1) ? sine: (switch[3] == 1) ? sine: (switch[4] == 1) ? sine: (switch[5] == 1) ? sine: (switch[6] == 1) ? sine: (switch[7] == 1) ? sine: 8'b0;
		
endmodule