`timescale 1ns / 1ps

module main (
   output [7:0] led,
	output [3:0] outpin,
	input switch,
	input switch2,
	input clk
   );
		
	reg [7:0] val;
	integer ctr = 0;
	integer led_ctr = 0;
	integer blink_delay = 10000;
	
	reg [3:0] pinled = 'b1111;
	
	always @(posedge clk) begin
		ctr = ctr + 1;
		
		if (ctr > blink_delay) begin
			pinled[0] = !pinled[0];
			pinled[1] = !pinled[1];
			pinled[2] = !pinled[2];
			pinled[3] = !pinled[3];
			
			val = !val;
			ctr = 0;
			val[led_ctr+1] = 1;
			val[led_ctr] = 0;
			
			case(switch)
				0: blink_delay <= 10000000;
				1: blink_delay <= 5000000;
			endcase
			
			if (led_ctr==6) begin
				led_ctr = 0; 
			end else begin
				led_ctr = led_ctr + 1;
			end
		end

	end
	assign led = val;
	assign outpin = pinled;
	

endmodule